<?php
$container_layout_choices = apply_filters(
	'colormag_container_layout_choices',
	array(
		'default'                      => array(
			'label' => 'Inherit',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/inherit.svg',
		),
		'no_sidebar_full_width'        => array(
			'label' => 'Normal',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/normal.svg',
		),
		'no_sidebar_content_centered'  => array(
			'label' => 'Narrow',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/narrow.svg',
		),
		'no_sidebar_content_stretched' => array(
			'label' => 'Full Width',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/full-width.svg',
		),
	)
);

$sidebar_layout_choices = apply_filters(
	'colormag_site_layout_choices',
	array(
		'default'       => array(
			'label' => 'Inherit',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/inherit.svg',
		),
		'no_sidebar'    => array(
			'label' => 'No Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/no-sidebar.svg',
		),
		'right_sidebar' => array(
			'label' => 'Right Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/right-sidebar.svg',
		),
		'left_sidebar'  => array(
			'label' => 'Left Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/left-sidebar.svg',
		),
		'two_sidebars'  => array(
			'label' => 'Both Sidebar',
			'url'   => COLORMAG_PARENT_URL . '/assets/img/sidebar/both-sidebar.svg',
		),
	)
);

$options = array(
	'colormag_single_post_container_tab_group'    => array(
		'type'      => 'customind-tabs',
		'title'     => esc_html__( 'Single Post', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tabs'      => array(
			'general' => esc_html__( 'General', 'colormag' ),
			'style'   => esc_html__( 'Style', 'colormag' ),
		),
		'default'   => 'general',
	),
	'colormag_single_post_container_layout'       => array(
		'default'   => 'default',
		'type'      => 'customind-radio-image',
		'title'     => esc_html__( 'Container Layout', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'choices'   => $container_layout_choices,
		'columns'   => 2,
		'priority'  => 10,
	),
	'colormag_single_post_sidebar_layout_divider' => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab'       => 'general',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
	'colormag_single_post_sidebar_layout'         => array(
		'default'    => 'default',
		'type'       => 'customind-radio-image',
		'title'      => esc_html__( 'Sidebar Layout', 'colormag' ),
		'section'    => 'colormag_single_post_section',
		'tab_group'  => 'colormag_single_post_container_tab_group',
		'tab'        => 'general',
		'choices'    => $sidebar_layout_choices,
		'columns'    => 2,
		'priority'   => 10,
		'conditions' => array(
			'relation' => 'OR',
			'terms'    => array(
				// Simple condition
				array(
					'id'       => 'colormag_single_post_container_layout',
					'operator' => '===',
					'value'    => 'no_sidebar_full_width',
				),
				// Nested condition
				array(
					'relation' => 'AND',
					'terms'    => array(
						array(
							'id'       => 'colormag_single_post_container_layout',
							'operator' => '===',
							'value'    => 'default',
						),
						array(
							'id'       => 'colormag_global_container_layout',
							'operator' => '===',
							'value'    => 'no_sidebar_full_width',
						),
					),
				),
			),
		),
	),
	'colormag_single_post_layout_divider'         => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab'       => 'general',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
	'colormag_autoload_posts_heading'             => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Autoload Posts', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_enable_autoload_posts'              => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'tab'       => 'general',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
	),
	'colormag_autoload_posts_filter'              => array(
		'default'   => 'previous_posts',
		'type'      => 'customind-select',
		'tab'       => 'general',
		'title'     => esc_html__( 'Filter', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'choices'   => array(
			'previous_posts' => esc_html__( 'Previous posts', 'colormag' ),
			'next_posts'     => esc_html__( 'Next posts', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_autoload_posts' => true,
		),
	),
	'colormag_autoload_posts_type'                => array(
		'default'   => 'button',
		'type'      => 'customind-select',
		'tab'       => 'general',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'choices'   => array(
			'button' => esc_html__( 'Button', 'colormag' ),
			'scroll' => esc_html__( 'Scroll', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_autoload_posts' => true,
		),
	),
	'colormag_autoload_posts_limit'               => array(
		'default'     => 2,
		'type'        => 'customind-text',
		'tab'         => 'general',
		'title'       => esc_html__( 'Number of Posts', 'colormag' ),
		'section'     => 'colormag_single_post_section',
		'tab_group'   => 'colormag_single_post_container_tab_group',
		'input_attrs' => array(
			'type' => 'number',
			'min'  => 1,
			'max'  => 5,
		),
		'condition'   => array(
			'colormag_enable_autoload_posts' => true,
		),
	),
	'colormag_author_bio_heading'                 => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Author Bio', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_enable_author_bio'                  => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
	),
	'colormag_enable_author_bio_profile'          => array(
		'title'     => esc_html__( 'Social profiles', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector' => '.author-social-sites',
		),
		'condition' => array(
			'colormag_enable_author_bio' => true,
		),
	),
	'colormag_enable_author_bio_link'             => array(
		'title'     => esc_html__( 'Link to Author Page', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector' => '.author-url',
		),
		'condition' => array(
			'colormag_enable_author_bio' => true,
		),
	),
	'colormag_author_bio_style'                   => array(
		'default'   => 'style-1',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'style-1' => esc_html__( 'Style 1', 'colormag' ),
			'style-2' => esc_html__( 'Style 2', 'colormag' ),
			'style-3' => esc_html__( 'Style 3', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_author_bio' => true,
		),
	),
	'colormag_single_post_elements_heading'       => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Post Elements', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_single_post_elements'               => array(
		'type'      => 'customind-sortable-v2',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'post_format' => array(
				'label'    => 'Image',
				'controls' => array(
					'colormag_enable_featured_image'    => array(
						'title'     => esc_html__( 'Enable', 'colormag' ),
						'default'   => true,
						'type'      => 'customind-toggle',
						'tab'       => 'general',
						'section'   => 'colormag_single_post_section',
						'tab_group' => 'colormag_single_post_container_tab_group',
						'transport' => 'refresh',
					),
					'colormag_blog_featured_image_size' => array(
						'default'   => 'large',
						'type'      => 'customind-select',
						'tab'       => 'general',
						'title'     => esc_html__( 'Image Size', 'colormag' ),
						'section'   => 'colormag_single_post_section',
						'tab_group' => 'colormag_single_post_container_tab_group',
						'choices'   => colormag_get_image_sizes(),
						'condition' => array(
							'colormag_enable_featured_image' => true,
						),
					),
					'colormag_enable_lightbox'          => array(
						'title'     => esc_html__( 'LightBox', 'colormag' ),
						'default'   => false,
						'type'      => 'customind-toggle',
						'tab'       => 'general',
						'section'   => 'colormag_single_post_section',
						'tab_group' => 'colormag_single_post_container_tab_group',
						'transport' => 'refresh',
						'condition' => array(
							'colormag_enable_featured_image' => true,
						),
					),
				),
			),
			'category'    => array(
				'label'    => 'category',
				'controls' => array(),
			),
			'title'       => array(
				'label'    => 'title',
				'controls' => array(),
			),
			'meta'        => array(
				'label'    => 'meta',
				'controls' => array(),
			),
			'content'     => array(
				'label'    => 'content',
				'controls' => array(),
			),
		),
		'default'   => array(
			'post_format',
			'category',
			'title',
			'meta',
			'content',
		),
	),
	'colormag_single_post_social_share_heading'   => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Social Share Button', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_enable_social_share'                => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector' => '.share-buttons',
		),
	),
	'colormag_enable_social_share_twitter'        => array(
		'title'     => esc_html__( 'Twitter', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector' => '.share-buttons',
		),
		'condition' => array(
			'colormag_enable_social_share' => true,
		),
	),
	'colormag_enable_social_share_facebook'       => array(
		'title'     => esc_html__( 'Facebook', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'tab'       => 'general',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'partial'   => array(
			'selector' => '.share-buttons',
		),
		'condition' => array(
			'colormag_enable_social_share' => true,
		),
	),
	'colormag_enable_social_share_pinterest'      => array(
		'title'     => esc_html__( 'Pinterest', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector' => '.share-buttons',
		),
		'condition' => array(
			'colormag_enable_social_share' => true,
		),
	),
	'colormag_enable_social_share_email'          => array(
		'title'     => esc_html__( 'Email', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector' => '.share-buttons',
		),
		'condition' => array(
			'colormag_enable_social_share' => true,
		),
	),
	'colormag_post_navigation_heading'            => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Post Navigation', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_enable_post_navigation'             => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => true,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
	),
	'colormag_post_navigation_style'              => array(
		'default'   => 'style-1',
		'type'      => 'customind-select',
		'tab'       => 'general',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'choices'   => array(
			'style-1' => esc_html__( 'Style 1', 'colormag' ),
			'style-2' => esc_html__( 'Style 2', 'colormag' ),
			'style-3' => esc_html__( 'Style 3', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_post_navigation' => true,
		),
	),
	'colormag_related_posts_heading'              => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Related Posts', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_enable_related_posts'               => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector' => '.related-posts',
		),
	),
	'colormag_you_may_also_like_text'             => array(
		'title'     => esc_html__( 'Heading', 'colormag' ),
		'default'   => esc_html__( 'You May Also Like', 'colormag' ),
		'type'      => 'customind-text',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector'        => '.related-posts-main-title',
			'render_callback' => array(
				'ColorMag_Customizer_Partials',
				'render_you_may_also_like_text',
			),
		),
		'condition' => array(
			'colormag_enable_related_posts' => true,
		),
	),
	'colormag_related_posts_query'                => array(
		'default'   => 'style-1',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Query', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'categories' => esc_html__( 'Categories', 'colormag' ),
			'tags'       => esc_html__( 'Tags', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_related_posts' => true,
		),
	),
	'colormag_related_posts_count'                => array(
		'default'   => '3',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Query Count', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'2'  => esc_html__( '2', 'colormag' ),
			'3'  => esc_html__( '3', 'colormag' ),
			'4'  => esc_html__( '4', 'colormag' ),
			'5'  => esc_html__( '5', 'colormag' ),
			'6'  => esc_html__( '6', 'colormag' ),
			'7'  => esc_html__( '7', 'colormag' ),
			'8'  => esc_html__( '8', 'colormag' ),
			'9'  => esc_html__( '9', 'colormag' ),
			'10' => esc_html__( '10', 'colormag' ),
			'11' => esc_html__( '11', 'colormag' ),
			'12' => esc_html__( '12', 'colormag' ),
			'13' => esc_html__( '13', 'colormag' ),
			'14' => esc_html__( '14', 'colormag' ),
			'15' => esc_html__( '15', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_related_posts' => true,
		),
	),
	'colormag_related_posts_style'                => array(
		'default'   => 'style-1',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Style', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'style-1' => esc_html__( 'Style 1', 'colormag' ),
			'style-2' => esc_html__( 'Style 2', 'colormag' ),
			'style-3' => esc_html__( 'Style 3', 'colormag' ),
			'style-4' => esc_html__( 'Style 4', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_related_posts' => true,
		),
	),
	'colormag_flyout_related_posts_heading'       => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Flyout Related Posts', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_enable_flyout_related_posts'        => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
	),
	'colormag_read_next_text'                     => array(
		'title'     => esc_html__( 'Heading', 'colormag' ),
		'default'   => esc_html__( 'Read Next', 'colormag' ),
		'type'      => 'customind-text',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
		'tab'       => 'general',
		'partial'   => array(
			'selector'        => '.related-posts-flyout-main-title',
			'render_callback' => array(
				'ColorMag_Customizer_Partials',
				'render_read_next_text',
			),
		),
		'condition' => array(
			'colormag_enable_flyout_related_posts' => true,
		),
	),
	'colormag_flyout_related_posts_query'         => array(
		'default'   => 'categories',
		'type'      => 'customind-select',
		'title'     => esc_html__( 'Query', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'categories' => esc_html__( 'Categories', 'colormag' ),
			'tags'       => esc_html__( 'Tags', 'colormag' ),
			'date'       => esc_html__( 'Date', 'colormag' ),
		),
		'condition' => array(
			'colormag_enable_flyout_related_posts' => true,
		),
	),
	'colormag_related_posts_flyout_by_date'       => array(
		'type'      => 'customind-date',
		'title'     => esc_html__( 'Show Posts After', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'condition' => array(
			'colormag_enable_flyout_related_posts' => true,
			'colormag_flyout_related_posts_query'  => 'date',
		),
	),
	'colormag_reading_progress_indicator_heading' => array(
		'type'      => 'customind-heading',
		'title'     => esc_html__( 'Reading Progress Indicator', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
	),
	'colormag_enable_progress_bar_indicator'      => array(
		'title'     => esc_html__( 'Enable', 'colormag' ),
		'default'   => false,
		'type'      => 'customind-toggle',
		'tab'       => 'general',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'transport' => 'refresh',
	),
	'colormag_single_post_meta_heading'           => array(
		'type'        => 'customind-heading',
		'title'       => esc_html__( 'Post Meta', 'colormag' ),
		'section'     => 'colormag_single_post_section',
		'tab_group'   => 'colormag_single_post_container_tab_group',
		'description' => esc_html__( 'Manage the post meta elements such as Categories, Author, Date, Comments, Tags, etc.', 'colormag' ),
		'tab'         => 'general',
	),
	'colormag_single_post_meta_structure'         => array(
		'type'      => 'customind-sortable-v2',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'tab'       => 'general',
		'choices'   => array(
			'author'      => array(
				'label'    => 'author',
				'controls' => array(
					'colormag_single_post_meta_author_style'         => array(
						'default'   => 'style-1',
						'type'      => 'customind-select',
						'title'     => esc_html__( 'Author Style', 'colormag' ),
						'section'   => 'colormag_single_post_section',
						'tab_group' => 'colormag_single_post_container_tab_group',
						'tab'       => 'general',
						'choices'   => array(
							'style-1' => esc_html__( 'Style 1', 'colormag' ),
							'style-2' => esc_html__( 'Style 2', 'colormag' ),
						),
					),
				),
			),
			'date'        => array(
				'label'    => 'date',
				'controls' => array(
					'colormag_single_post_meta_date_style' => array(
						'default'   => 'style-1',
						'type'      => 'customind-select',
						'title'     => esc_html__( 'Post Date Style', 'colormag' ),
						'section'   => 'colormag_single_post_section',
						'tab_group' => 'colormag_single_post_container_tab_group',
						'tab'       => 'general',
						'choices'   => array(
							'style-1' => esc_html__( 'Style 1', 'colormag' ),
							'style-2' => esc_html__( 'Style 2', 'colormag' ),
						),
					),
				),
			),
			'views'       => array(
				'label'    => 'views',
				'controls' => array(),
			),
			'comments'    => array(
				'label'    => 'comments',
				'controls' => array(),
			),
			'tags'        => array(
				'label'    => 'content',
				'controls' => array(),
			),
			'read-time'   => array(
				'label'    => 'read-time',
				'controls' => array(),
			),
			'edit-button' => array(
				'label'    => 'edit-button',
				'controls' => array(),
			),
		),
		'default'   => array(
			'categories',
			'date',
			'author',
		),
	),
	'colormag_progress_bar_indicator_color'       => array(
		'title'     => esc_html__( 'Reading Progress Indicator', 'colormag' ),
		'default'   => '#222222',
		'type'      => 'customind-color',
		'tab'       => 'style',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
		'condition' => array(
			'colormag_enable_progress_bar_indicator' => true,
		),
	),
	'colormag_single_post_divider_subtitle'       => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab'       => 'style',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
	'colormag_post_title_color'                   => array(
		'title'     => esc_html__( 'Post Title', 'colormag' ),
		'default'   => '#333333',
		'type'      => 'customind-color',
		'transport' => 'postMessage',
		'tab'       => 'style',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
	'colormag_single_post_title_typography'       => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => '500',
			'font-size'      => array(
				'desktop' => array(
					'size' => '',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => 'px',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => 'px',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.3',
					'unit' => '',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'title'     => esc_html__( 'Font', 'colormag' ),
		'transport' => 'postMessage',
		'tab'       => 'style',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
	'colormag_comment_title_typography'           => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '24',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => 'px',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => 'px',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.6',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '-',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '-',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'transport' => 'postMessage',
		'tab'       => 'style',
		'title'     => esc_html__( 'Comment Typography', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
	'colormag_single_post_divider_2_subtitle'     => array(
		'type'      => 'customind-divider',
		'variant'   => 'dashed',
		'tab'       => 'style',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
	'colormag_single_post_meta_color'             => array(
		'title'     => esc_html__( 'Post Meta Text Color', 'colormag' ),
		'default'   => '#71717A',
		'type'      => 'customind-color',
		'tab'       => 'style',
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
	'colormag_single_post_meta_typography'        => array(
		'default'   => array(
			'font-family'    => 'inherit',
			'font-weight'    => 'regular',
			'subsets'        => array( 'latin' ),
			'font-size'      => array(
				'desktop' => array(
					'size' => '12',
					'unit' => 'px',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => 'px',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => 'px',
				),
			),
			'line-height'    => array(
				'desktop' => array(
					'size' => '1.6',
					'unit' => '-',
				),
				'tablet'  => array(
					'size' => '',
					'unit' => '-',
				),
				'mobile'  => array(
					'size' => '',
					'unit' => '-',
				),
			),
			'font-style'     => 'normal',
			'text-transform' => 'none',
		),
		'type'      => 'customind-typography',
		'tab'       => 'style',
		'title'     => esc_html__( 'Font', 'colormag' ),
		'section'   => 'colormag_single_post_section',
		'tab_group' => 'colormag_single_post_container_tab_group',
	),
);

colormag_customind()->add_controls( $options );
